###解説1
import ctypes
import tisgrabber as tis

# ============================================================
# Init
# ============================================================
ic = ctypes.cdll.LoadLibrary("./tisgrabber_x64.dll")
tis.declareFunctions(ic)
ic.IC_InitLibrary(0)

# hGrabber = ic.IC_ShowDeviceSelectionDialog(None)
# if not ic.IC_IsDevValid(hGrabber):
#     print("デバイスを開けませんでした。")
#     raise SystemExit(1)


#新しいグラバーハンドルを作成します。
hGrabber = ic.IC_CreateGrabber()
#デバイスをオープンします。
ic.IC_OpenVideoCaptureDevice(hGrabber, tis.T("DMK 33UX264"))
#ic.IC_OpenVideoCaptureDevice(hGrabber, tis.T("DFK 39GR0522-Z12"))
#ic.IC_OpenVideoCaptureDevice(hGrabber, tis.T("DFG/HDMI"))

if(ic.IC_IsDevValid(hGrabber)):
    ic.IC_printItemandElementNames(hGrabber)
else:
    print("No device opened.")
    raise SystemExit(1)


#　カラーRGB32
ic.IC_SetVideoFormat(hGrabber, tis.T("RGB32 (640x480)"))
# モノクロY800
#ic.IC_SetVideoFormat(hGrabber, tis.T("Y800 (640x480)"))

# ビニング処理
# ic.IC_SetVideoFormat(hGrabber, tis.T("RGB32 (640x480) [Binning 2x]"))
# スキッピング処理
# ic.IC_SetVideoFormat(hGrabber, tis.T("RGB32 (640x480) [Skipping 2x]"))

ic.IC_SetFrameRate(hGrabber, ctypes.c_float(30.0))
#ライブスタート開始　引数：0の時非表示、引数：1の時非表示
ic.IC_StartLive(hGrabber, 1)

# ============================================================
# Startup Behaviorタブ
# ============================================================
#Startup Behavior Save Save Current State
print("[Button] Startup Behavior / Save Current State")
ic.IC_PropertyOnePush(hGrabber, tis.T("Startup Behavior"), tis.T("Save Current State"))
print("------------------------------------------------------------")

#Startup Behavior Save Save Current State
print("[Button] Startup Behavior / Restore Factory Default")
ic.IC_PropertyOnePush(hGrabber, tis.T("Startup Behavior"), tis.T("Restore Factory Default"))
print("------------------------------------------------------------")

#Startup Behavior ReadOnly
startup_status1 = ctypes.c_long()
startup_status2 = ctypes.c_long()
r = ic.IC_GetPropertyValue(hGrabber, tis.T("Startup Behavior"), tis.T("Status"), startup_status1)
print(f"[MapStrings] Startup Behavior / Status GET  ret={r} idx={startup_status1.value}")
print("------------------------------------------------------------\n")


# ============================================================
# 露光タブ
# ============================================================
#明度
brightness1 = ctypes.c_long()
brightness2 = ctypes.c_long()
r = ic.IC_GetPropertyValue(hGrabber, tis.T("Brightness"), tis.T("Value"), brightness1)
print(f"[Range] Brightness / Value GET  ret={r} value={brightness1.value}")
ic.IC_SetPropertyValue(hGrabber, tis.T("Brightness"), tis.T("Value"), 240)
r = ic.IC_GetPropertyValue(hGrabber, tis.T("Brightness"), tis.T("Value"), brightness2)
print(f"[Range] Brightness / Value GET2 ret={r} value={brightness2.value}")
print("------------------------------------------------------------\n")

#コントラスト
contrast1 = ctypes.c_long()
contrast2 = ctypes.c_long()
r = ic.IC_GetPropertyValue(hGrabber, tis.T("Contrast"), tis.T("Value"), contrast1)
print(f"[Range] Contrast / Value GET  ret={r} value={contrast1.value}")
ic.IC_SetPropertyValue(hGrabber, tis.T("Contrast"), tis.T("Value"), 0)
r = ic.IC_GetPropertyValue(hGrabber, tis.T("Contrast"), tis.T("Value"), contrast2)
print(f"[Range] Contrast / Value GET2 ret={r} value={contrast2.value}")
print("------------------------------------------------------------\n")

#ゲイン
gain_abs1 = ctypes.c_float()
gain_abs2 = ctypes.c_float()
r = ic.IC_GetPropertyAbsoluteValue(hGrabber, tis.T("Gain"), tis.T("Value"), gain_abs1)
print(f"[Abs]  Gain / Value GET  ret={r} value={float(gain_abs1.value)}")
ic.IC_SetPropertyAbsoluteValue(hGrabber, tis.T("Gain"), tis.T("Value"), ctypes.c_float(1))
r = ic.IC_GetPropertyAbsoluteValue(hGrabber, tis.T("Gain"), tis.T("Value"), gain_abs2)
print(f"[Abs]  Gain / Value GET2 ret={r} value={float(gain_abs2.value)}")
print("------------------------------------------------------------")

#ゲイン自動 On/Off
gain_auto1 = ctypes.c_long()
gain_auto2 = ctypes.c_long()
r = ic.IC_GetPropertySwitch(hGrabber, tis.T("Gain"), tis.T("Auto"), gain_auto1)
print(f"[Switch] Gain / Auto GET  ret={r} value={gain_auto1.value}")
ic.IC_SetPropertySwitch(hGrabber, tis.T("Gain"), tis.T("Auto"),0)
r = ic.IC_GetPropertySwitch(hGrabber, tis.T("Gain"), tis.T("Auto"), gain_auto2)
print(f"[Switch] Gain / Auto GET2 ret={r} value={gain_auto2.value}")
print("------------------------------------------------------------")

#ゲイン自動最大値
gain_amv_abs1 = ctypes.c_float()
gain_amv_abs2 = ctypes.c_float()
r = ic.IC_GetPropertyAbsoluteValue(hGrabber, tis.T("Gain"), tis.T("Auto Max Value"), gain_amv_abs1)
print(f"[Abs]  Gain / Auto Max Value GET  ret={r} value={float(gain_amv_abs1.value)}")
ic.IC_SetPropertyAbsoluteValue(hGrabber, tis.T("Gain"), tis.T("Auto Max Value"),  ctypes.c_float(20))
r = ic.IC_GetPropertyAbsoluteValue(hGrabber, tis.T("Gain"), tis.T("Auto Max Value"), gain_amv_abs2)
print(f"[Abs]  Gain / Auto Max Value GET2 ret={r} value={float(gain_amv_abs2.value)}")
print("------------------------------------------------------------")

#露光
exp_abs1 = ctypes.c_float()
exp_abs2 = ctypes.c_float()
r = ic.IC_GetPropertyAbsoluteValue(hGrabber, tis.T("Exposure"), tis.T("Value"), exp_abs1)
print(f"[Abs]  Exposure / Value GET  ret={r} value={float(exp_abs1.value)}")
ic.IC_SetPropertyAbsoluteValue(hGrabber, tis.T("Exposure"), tis.T("Value"), ctypes.c_float(1000.0))
r = ic.IC_GetPropertyAbsoluteValue(hGrabber, tis.T("Exposure"), tis.T("Value"), exp_abs2)
print(f"[Abs]  Exposure / Value GET2 ret={r} value={float(exp_abs2.value)}")
print("------------------------------------------------------------")

#露光　自動　On/Off
exp_auto1 = ctypes.c_long()
exp_auto2 = ctypes.c_long()
r = ic.IC_GetPropertySwitch(hGrabber, tis.T("Exposure"), tis.T("Auto"), exp_auto1)
print(f"[Switch] Exposure / Auto GET  ret={r} value={exp_auto1.value}")
ic.IC_SetPropertySwitch(hGrabber, tis.T("Exposure"), tis.T("Auto"), 0)
r = ic.IC_GetPropertySwitch(hGrabber, tis.T("Exposure"), tis.T("Auto"), exp_auto2)
print(f"[Switch] Exposure / Auto GET2 ret={r} value={exp_auto2.value}")
print("------------------------------------------------------------")

#露光　最大値自動　On/Off
exp_ama1 = ctypes.c_long()
exp_ama2 = ctypes.c_long()
r = ic.IC_GetPropertySwitch(hGrabber, tis.T("Exposure"), tis.T("Auto Max Auto"), exp_ama1)
print(f"[Switch] Exposure / Auto Max Auto GET  ret={r} value={exp_ama1.value}")
ic.IC_SetPropertySwitch(hGrabber, tis.T("Exposure"), tis.T("Auto Max Auto"), 0)
r = ic.IC_GetPropertySwitch(hGrabber, tis.T("Exposure"), tis.T("Auto Max Auto"), exp_ama2)
print(f"[Switch] Exposure / Auto Max Auto GET2 ret={r} value={exp_ama2.value}")
print("------------------------------------------------------------\n")

#露光　自動リファレンス
exp_ar1 = ctypes.c_long()
exp_ar2 = ctypes.c_long()
r = ic.IC_GetPropertyValue(hGrabber, tis.T("Exposure"), tis.T("Auto Reference"), exp_ar1)
print(f"[Range] Exposure / Auto Reference GET  ret={r} value={exp_ar1.value}")
ic.IC_SetPropertyValue(hGrabber, tis.T("Exposure"), tis.T("Auto Reference"), 128)
r = ic.IC_GetPropertyValue(hGrabber, tis.T("Exposure"), tis.T("Auto Reference"), exp_ar2)
print(f"[Range] Exposure / Auto Reference GET2 ret={r} value={exp_ar2.value}")
print("------------------------------------------------------------")

#露光　自動最大値
exp_amv_abs1 = ctypes.c_float()
exp_amv_abs2 = ctypes.c_float()
r = ic.IC_GetPropertyAbsoluteValue(hGrabber, tis.T("Exposure"), tis.T("Auto Max Value"), exp_amv_abs1)
print(f"[Abs]  Exposure / Auto Max Value GET  ret={r} value={float(exp_amv_abs1.value)}")
ic.IC_SetPropertyAbsoluteValue(hGrabber, tis.T("Exposure"), tis.T("Auto Max Value"), ctypes.c_float(100))
r = ic.IC_GetPropertyAbsoluteValue(hGrabber, tis.T("Exposure"), tis.T("Auto Max Value"), exp_amv_abs2)
print(f"[Abs]  Exposure / Auto Max Value GET2 ret={r} value={float(exp_amv_abs2.value)}")
print("------------------------------------------------------------")


# Highlight Reduction
hr1 = ctypes.c_long()
hr2 = ctypes.c_long()
r = ic.IC_GetPropertySwitch(hGrabber, tis.T("Highlight Reduction"), tis.T("Enable"), hr1)
print(f"[Switch] Highlight Reduction / Enable GET  ret={r} value={hr1.value}")
ic.IC_SetPropertySwitch(hGrabber, tis.T("Highlight Reduction"), tis.T("Enable"), 1)
r = ic.IC_GetPropertySwitch(hGrabber, tis.T("Highlight Reduction"), tis.T("Enable"), hr2)
print(f"[Switch] Highlight Reduction / Enable GET2 ret={r} value={hr2.value}")
print("------------------------------------------------------------\n")


# ============================================================
# イメージタブ
# ============================================================
#シャープネス
sharp1 = ctypes.c_long()
sharp2 = ctypes.c_long()
r = ic.IC_GetPropertyValue(hGrabber, tis.T("Sharpness"), tis.T("Value"), sharp1)
print(f"[Range] Sharpness / Value GET  ret={r} value={sharp1.value}")
ic.IC_SetPropertyValue(hGrabber, tis.T("Sharpness"), tis.T("Value"), 0)
r = ic.IC_GetPropertyValue(hGrabber, tis.T("Sharpness"), tis.T("Value"), sharp2)
print(f"[Range] Sharpness / Value GET2 ret={r} value={sharp2.value}")
print("------------------------------------------------------------\n")

#ガンマ
gamma_abs1 = ctypes.c_float()
gamma_abs2 = ctypes.c_float()
r = ic.IC_GetPropertyAbsoluteValue(hGrabber, tis.T("Gamma"), tis.T("Value"), gamma_abs1)
print(f"[Abs]  Gamma / Value GET  ret={r} value={float(gamma_abs1.value)}")
ic.IC_SetPropertyAbsoluteValue(hGrabber, tis.T("Gamma"), tis.T("Value"), 1)
r = ic.IC_GetPropertyAbsoluteValue(hGrabber, tis.T("Gamma"), tis.T("Value"), gamma_abs2)
print(f"[Abs]  Gamma / Value GET2 ret={r} value={float(gamma_abs2.value)}")
print("------------------------------------------------------------")

#Denoise
dn1 = ctypes.c_long()
dn2 = ctypes.c_long()
r = ic.IC_GetPropertyValue(hGrabber, tis.T("Denoise"), tis.T("Value"), dn1)
print(f"[Range] Denoise / Value GET  ret={r} value={dn1.value}")
ic.IC_SetPropertyValue(hGrabber, tis.T("Denoise"), tis.T("Value"), 1)
r = ic.IC_GetPropertyValue(hGrabber, tis.T("Denoise"), tis.T("Value"), dn2)
print(f"[Range] Denoise / Value GET2 ret={r} value={dn2.value}")
print("------------------------------------------------------------\n")

#Flip Horizontal(垂直反転)
fh1 = ctypes.c_long()
fh2 = ctypes.c_long()
r = ic.IC_GetPropertySwitch(hGrabber, tis.T("Flip Horizontal"), tis.T("Enable"), fh1)
print(f"[Switch] Flip Horizontal / Enable GET  ret={r} value={fh1.value}")
ic.IC_SetPropertySwitch(hGrabber, tis.T("Flip Horizontal"), tis.T("Enable"), 0)
r = ic.IC_GetPropertySwitch(hGrabber, tis.T("Flip Horizontal"), tis.T("Enable"), fh2)
print(f"[Switch] Flip Horizontal / Enable GET2 ret={r} value={fh2.value}")
print("------------------------------------------------------------\n")

#Flip Vertical(水平反転)
fv1 = ctypes.c_long()
fv2 = ctypes.c_long()
r = ic.IC_GetPropertySwitch(hGrabber, tis.T("Flip Vertical"), tis.T("Enable"), fv1)
print(f"[Switch] Flip Vertical / Enable GET  ret={r} value={fv1.value}")
ic.IC_SetPropertySwitch(hGrabber, tis.T("Flip Vertical"), tis.T("Enable"), 0)
r = ic.IC_GetPropertySwitch(hGrabber, tis.T("Flip Vertical"), tis.T("Enable"), fv2)
print(f"[Switch] Flip Vertical / Enable GET2 ret={r} value={fv2.value}")
print("------------------------------------------------------------\n")

# ============================================================
# イメージタブ
# ============================================================

#色調
hue1 = ctypes.c_long()
hue2 = ctypes.c_long()
r = ic.IC_GetPropertyValue(hGrabber, tis.T("Hue"), tis.T("Value"), hue1)
print(f"[Range] Hue / Value GET  ret={r} value={hue1.value}")
ic.IC_SetPropertyValue(hGrabber, tis.T("Hue"), tis.T("Value"), 0)
r = ic.IC_GetPropertyValue(hGrabber, tis.T("Hue"), tis.T("Value"), hue2)
print(f"[Range] Hue / Value GET2 ret={r} value={hue2.value}")
print("------------------------------------------------------------\n")

#彩度
sat_abs1 = ctypes.c_float()
sat_abs2 = ctypes.c_float()
r = ic.IC_GetPropertyAbsoluteValue(hGrabber, tis.T("Saturation"), tis.T("Value"), sat_abs1)
print(f"[Abs]  Saturation / Value GET  ret={r} value={float(sat_abs1.value)}")
ic.IC_SetPropertyAbsoluteValue(hGrabber, tis.T("Saturation"), tis.T("Value"), 100)
r = ic.IC_GetPropertyAbsoluteValue(hGrabber, tis.T("Saturation"), tis.T("Value"), sat_abs2)
print(f"[Abs]  Saturation / Value GET2 ret={r} value={float(sat_abs2.value)}")
print("------------------------------------------------------------")

#ホワイトバランス自動
wb_auto1 = ctypes.c_long()
wb_auto2 = ctypes.c_long()
r = ic.IC_GetPropertySwitch(hGrabber, tis.T("WhiteBalance"), tis.T("Auto"), wb_auto1)
print(f"[Switch] WhiteBalance / Auto GET  ret={r} value={wb_auto1.value}")
ic.IC_SetPropertySwitch(hGrabber, tis.T("WhiteBalance"), tis.T("Auto"), 0)
r = ic.IC_GetPropertySwitch(hGrabber, tis.T("WhiteBalance"), tis.T("Auto"), wb_auto2)
print(f"[Switch] WhiteBalance / Auto GET2 ret={r} value={wb_auto2.value}")
print("------------------------------------------------------------")
#ホワイトバランス　ワンプッシュボタン
print("[Button] WhiteBalance / One Push")
ic.IC_PropertyOnePush(hGrabber, tis.T("WhiteBalance"), tis.T("One Push"))
print("------------------------------------------------------------")

#ホワイトバランス　WhiteBalance Mode
wb_mode1 = ctypes.c_long()
wb_mode2 = ctypes.c_long()
r = ic.IC_GetPropertyValue(hGrabber, tis.T("WhiteBalance"), tis.T("WhiteBalance Mode"), wb_mode1)
print(f"[MapStrings] WhiteBalance / WhiteBalance Mode GET  ret={r} idx={wb_mode1.value}")
ic.IC_SetPropertyValue(hGrabber, tis.T("WhiteBalance"), tis.T("WhiteBalance Mode"), 0)
r = ic.IC_GetPropertyValue(hGrabber, tis.T("WhiteBalance"), tis.T("WhiteBalance Mode"), wb_mode2)
print(f"[MapStrings] WhiteBalance / WhiteBalance Mode GET2 ret={r} idx={wb_mode2.value}")
print("------------------------------------------------------------")

#ホワイトバランス　Auto Preset
wb_auto_preset1 = ctypes.c_long()
wb_auto_preset2 = ctypes.c_long()
r = ic.IC_GetPropertyValue(hGrabber, tis.T("WhiteBalance"), tis.T("Auto Preset"), wb_auto_preset1)
print(f"[MapStrings] WhiteBalance / Auto Preset GET  ret={r} idx={wb_auto_preset1.value}")
ic.IC_SetPropertyValue(hGrabber, tis.T("WhiteBalance"), tis.T("Auto Preset"), 0)
r = ic.IC_GetPropertyValue(hGrabber, tis.T("WhiteBalance"), tis.T("Auto Preset"), wb_auto_preset2)
print(f"[MapStrings] WhiteBalance / Auto Preset GET2 ret={r} idx={wb_auto_preset2.value}")
print("------------------------------------------------------------")

#ホワイトバランス　Temperature Preset
wb_temp_preset1 = ctypes.c_long()
wb_temp_preset2 = ctypes.c_long()
r = ic.IC_GetPropertyValue(hGrabber, tis.T("WhiteBalance"), tis.T("Temperature Preset"), wb_temp_preset1)
print(f"[MapStrings] WhiteBalance / Temperature Preset GET  ret={r} idx={wb_temp_preset1.value}")
ic.IC_SetPropertyValue(hGrabber, tis.T("WhiteBalance"), tis.T("Temperature Preset"), 0)
r = ic.IC_GetPropertyValue(hGrabber, tis.T("WhiteBalance"), tis.T("Temperature Preset"), wb_temp_preset2)
print(f"[MapStrings] WhiteBalance / Temperature Preset GET2 ret={r} idx={wb_temp_preset2.value}")
print("------------------------------------------------------------")

#ホワイトバランス　Temperature
wb_temp1 = ctypes.c_long()
wb_temp2 = ctypes.c_long()
r = ic.IC_GetPropertyValue(hGrabber, tis.T("WhiteBalance"), tis.T("Temperature"), wb_temp1)
print(f"[Range] WhiteBalance / Temperature GET  ret={r} value={wb_temp1.value}")
ic.IC_SetPropertyValue(hGrabber, tis.T("WhiteBalance"), tis.T("Temperature"), 4000)
r = ic.IC_GetPropertyValue(hGrabber, tis.T("WhiteBalance"), tis.T("Temperature"), wb_temp2)
print(f"[Range] WhiteBalance / Temperature GET2 ret={r} value={wb_temp2.value}")
print("------------------------------------------------------------")

#ホワイトバランス　ホワイトバランスRed
wb_red_abs1 = ctypes.c_float()
wb_red_abs2 = ctypes.c_float()
r = ic.IC_GetPropertyAbsoluteValue(hGrabber, tis.T("WhiteBalance"), tis.T("White Balance Red"), wb_red_abs1)
print(f"[Abs]  WhiteBalance / White Balance Red GET  ret={r} value={float(wb_red_abs1.value)}")
ic.IC_SetPropertyAbsoluteValue(hGrabber, tis.T("WhiteBalance"), tis.T("White Balance Red"), ctypes.c_float(1))
r = ic.IC_GetPropertyAbsoluteValue(hGrabber, tis.T("WhiteBalance"), tis.T("White Balance Red"), wb_red_abs2)
print(f"[Abs]  WhiteBalance / White Balance Red GET2 ret={r} value={float(wb_red_abs2.value)}")
print("------------------------------------------------------------")

#ホワイトバランス　ホワイトバランスGreen
wb_green_abs1 = ctypes.c_float()
wb_green_abs2 = ctypes.c_float()
r = ic.IC_GetPropertyAbsoluteValue(hGrabber, tis.T("WhiteBalance"), tis.T("White Balance Green"), wb_green_abs1)
print(f"[Abs]  WhiteBalance / White Balance Green GET  ret={r} value={float(wb_green_abs1.value)}")
ic.IC_SetPropertyAbsoluteValue(hGrabber, tis.T("WhiteBalance"), tis.T("White Balance Green"), ctypes.c_float(1))
r = ic.IC_GetPropertyAbsoluteValue(hGrabber, tis.T("WhiteBalance"), tis.T("White Balance Green"), wb_green_abs2)
print(f"[Abs]  WhiteBalance / White Balance Green GET2 ret={r} value={float(wb_green_abs2.value)}")
print("------------------------------------------------------------")

#ホワイトバランス　ホワイトバランスBlue
wb_blue_abs1 = ctypes.c_float()
wb_blue_abs2 = ctypes.c_float()
r = ic.IC_GetPropertyAbsoluteValue(hGrabber, tis.T("WhiteBalance"), tis.T("White Balance Blue"), wb_blue_abs1)
print(f"[Abs]  WhiteBalance / White Balance Blue GET  ret={r} value={float(wb_blue_abs1.value)}")
ic.IC_SetPropertyAbsoluteValue(hGrabber, tis.T("WhiteBalance"), tis.T("White Balance Blue"), ctypes.c_float(1))
r = ic.IC_GetPropertyAbsoluteValue(hGrabber, tis.T("WhiteBalance"), tis.T("White Balance Blue"), wb_blue_abs2)
print(f"[Abs]  WhiteBalance / White Balance Blue GET2 ret={r} value={float(wb_blue_abs2.value)}")
print("------------------------------------------------------------\n")






# ============================================================
# Multi-Frame Output Mode
# ============================================================
#Multi-Frame Output Mode　On/Off
mf_enable1 = ctypes.c_long()
mf_enable2 = ctypes.c_long()
r = ic.IC_GetPropertySwitch(hGrabber, tis.T("Multi-Frame Output Mode"), tis.T("Enable"), mf_enable1)
print(f"[Switch] Multi-Frame Output Mode / Enable GET  ret={r} value={mf_enable1.value}")
ic.IC_SetPropertySwitch(hGrabber, tis.T("Multi-Frame Output Mode"), tis.T("Enable"), 0)
r = ic.IC_GetPropertySwitch(hGrabber, tis.T("Multi-Frame Output Mode"), tis.T("Enable"), mf_enable2)
print(f"[Switch] Multi-Frame Output Mode / Enable GET2 ret={r} value={mf_enable2.value}")
print("------------------------------------------------------------")
#Multi-Frame Output Mode　Frame Count
mf_fc1 = ctypes.c_long()
mf_fc2 = ctypes.c_long()
r = ic.IC_GetPropertyValue(hGrabber, tis.T("Multi-Frame Output Mode"), tis.T("Frame Count"), mf_fc1)
print(f"[MapStrings] Multi-Frame Output Mode / Frame Count GET  ret={r} idx={mf_fc1.value}")
ic.IC_SetPropertyValue(hGrabber, tis.T("Multi-Frame Output Mode"), tis.T("Frame Count"), 1)
r = ic.IC_GetPropertyValue(hGrabber, tis.T("Multi-Frame Output Mode"), tis.T("Frame Count"), mf_fc2)
print(f"[MapStrings] Multi-Frame Output Mode / Frame Count GET2 ret={r} idx={mf_fc2.value}")
print("------------------------------------------------------------")
#Multi-Frame Output Mode　Exposure 0
mf_ex0_1 = ctypes.c_float()
mf_ex0_2 = ctypes.c_float()
r = ic.IC_GetPropertyAbsoluteValue(hGrabber, tis.T("Multi-Frame Output Mode"), tis.T("Exposure 0"), mf_ex0_1)
print(f"[Abs]  MFOM / Exposure 0 GET  ret={r} value={float(mf_ex0_1.value)}")
ic.IC_SetPropertyAbsoluteValue(hGrabber, tis.T("Multi-Frame Output Mode"), tis.T("Exposure 0"), ctypes.c_float(10))
r = ic.IC_GetPropertyAbsoluteValue(hGrabber, tis.T("Multi-Frame Output Mode"), tis.T("Exposure 0"), mf_ex0_2)
print(f"[Abs]  MFOM / Exposure 0 GET2 ret={r} value={float(mf_ex0_2.value)}")
print("------------------------------------------------------------")
#Multi-Frame Output Mode　Exposure 1
mf_ex1_1 = ctypes.c_float()
mf_ex1_2 = ctypes.c_float()
r = ic.IC_GetPropertyAbsoluteValue(hGrabber, tis.T("Multi-Frame Output Mode"), tis.T("Exposure 1"), mf_ex1_1)
print(f"[Abs]  MFOM / Exposure 1 GET  ret={r} value={float(mf_ex1_1.value)}")
ic.IC_SetPropertyAbsoluteValue(hGrabber, tis.T("Multi-Frame Output Mode"), tis.T("Exposure 1"), ctypes.c_float(20))
r = ic.IC_GetPropertyAbsoluteValue(hGrabber, tis.T("Multi-Frame Output Mode"), tis.T("Exposure 1"), mf_ex1_2)
print(f"[Abs]  MFOM / Exposure 1 GET2 ret={r} value={float(mf_ex1_2.value)}")
print("------------------------------------------------------------")
#Multi-Frame Output Mode　Exposure 2
mf_ex2_1 = ctypes.c_float()
mf_ex2_2 = ctypes.c_float()
r = ic.IC_GetPropertyAbsoluteValue(hGrabber, tis.T("Multi-Frame Output Mode"), tis.T("Exposure 2"), mf_ex2_1)
print(f"[Abs]  MFOM / Exposure 2 GET  ret={r} value={float(mf_ex2_1.value)}")
ic.IC_SetPropertyAbsoluteValue(hGrabber, tis.T("Multi-Frame Output Mode"), tis.T("Exposure 2"), ctypes.c_float(30))
r = ic.IC_GetPropertyAbsoluteValue(hGrabber, tis.T("Multi-Frame Output Mode"), tis.T("Exposure 2"), mf_ex2_2)
print(f"[Abs]  MFOM / Exposure 2 GET2 ret={r} value={float(mf_ex2_2.value)}")
print("------------------------------------------------------------")
#Multi-Frame Output Mode　Exposure 3
mf_ex3_1 = ctypes.c_float()
mf_ex3_2 = ctypes.c_float()
r = ic.IC_GetPropertyAbsoluteValue(hGrabber, tis.T("Multi-Frame Output Mode"), tis.T("Exposure 3"), mf_ex3_1)
print(f"[Abs]  MFOM / Exposure 3 GET  ret={r} value={float(mf_ex3_1.value)}")
ic.IC_SetPropertyAbsoluteValue(hGrabber, tis.T("Multi-Frame Output Mode"), tis.T("Exposure 3"), ctypes.c_float(40))
r = ic.IC_GetPropertyAbsoluteValue(hGrabber, tis.T("Multi-Frame Output Mode"), tis.T("Exposure 3"), mf_ex3_2)
print(f"[Abs]  MFOM / Exposure 3 GET2 ret={r} value={float(mf_ex3_2.value)}")
print("------------------------------------------------------------")
#Multi-Frame Output Mode　Customize Gain Values　On/Off
mf_cgv1 = ctypes.c_long()
mf_cgv2 = ctypes.c_long()
r = ic.IC_GetPropertySwitch(hGrabber, tis.T("Multi-Frame Output Mode"), tis.T("Customize Gain Values"), mf_cgv1)
print(f"[Switch] MFOM / Customize Gain Values GET  ret={r} value={mf_cgv1.value}")
ic.IC_SetPropertySwitch(hGrabber, tis.T("Multi-Frame Output Mode"), tis.T("Customize Gain Values"), 1)
r = ic.IC_GetPropertySwitch(hGrabber, tis.T("Multi-Frame Output Mode"), tis.T("Customize Gain Values"), mf_cgv2)
print(f"[Switch] MFOM / Customize Gain Values GET2 ret={r} value={mf_cgv2.value}")
print("------------------------------------------------------------")
#Multi-Frame Output Mode　Gain 0
mf_g0_1 = ctypes.c_float()
mf_g0_2 = ctypes.c_float()
r = ic.IC_GetPropertyAbsoluteValue(hGrabber, tis.T("Multi-Frame Output Mode"), tis.T("Gain 0"), mf_g0_1)
print(f"[Abs]  MFOM / Gain 0 GET  ret={r} value={float(mf_g0_1.value)}")
ic.IC_SetPropertyAbsoluteValue(hGrabber, tis.T("Multi-Frame Output Mode"), tis.T("Gain 0"), ctypes.c_float(0.0))
r = ic.IC_GetPropertyAbsoluteValue(hGrabber, tis.T("Multi-Frame Output Mode"), tis.T("Gain 0"), mf_g0_2)
print(f"[Abs]  MFOM / Gain 0 GET2 ret={r} value={float(mf_g0_2.value)}")
print("------------------------------------------------------------")
#Multi-Frame Output Mode　Gain 1
mf_g1_1 = ctypes.c_float()
mf_g1_2 = ctypes.c_float()
r = ic.IC_GetPropertyAbsoluteValue(hGrabber, tis.T("Multi-Frame Output Mode"), tis.T("Gain 1"), mf_g1_1)
print(f"[Abs]  MFOM / Gain 1 GET  ret={r} value={float(mf_g1_1.value)}")
ic.IC_SetPropertyAbsoluteValue(hGrabber, tis.T("Multi-Frame Output Mode"), tis.T("Gain 1"), ctypes.c_float(1.0))
r = ic.IC_GetPropertyAbsoluteValue(hGrabber, tis.T("Multi-Frame Output Mode"), tis.T("Gain 1"), mf_g1_2)
print(f"[Abs]  MFOM / Gain 1 GET2 ret={r} value={float(mf_g1_2.value)}")
print("------------------------------------------------------------")
#Multi-Frame Output Mode　Gain 2
mf_g2_1 = ctypes.c_float()
mf_g2_2 = ctypes.c_float()
r = ic.IC_GetPropertyAbsoluteValue(hGrabber, tis.T("Multi-Frame Output Mode"), tis.T("Gain 2"), mf_g2_1)
print(f"[Abs]  MFOM / Gain 2 GET  ret={r} value={float(mf_g2_1.value)}")
ic.IC_SetPropertyAbsoluteValue(hGrabber, tis.T("Multi-Frame Output Mode"), tis.T("Gain 2"), ctypes.c_float(2.0))
r = ic.IC_GetPropertyAbsoluteValue(hGrabber, tis.T("Multi-Frame Output Mode"), tis.T("Gain 2"), mf_g2_2)
print(f"[Abs]  MFOM / Gain 2 GET2 ret={r} value={float(mf_g2_2.value)}")
print("------------------------------------------------------------")
#Multi-Frame Output Mode　Gain 3
mf_g3_1 = ctypes.c_float()
mf_g3_2 = ctypes.c_float()
r = ic.IC_GetPropertyAbsoluteValue(hGrabber, tis.T("Multi-Frame Output Mode"), tis.T("Gain 3"), mf_g3_1)
print(f"[Abs]  MFOM / Gain 3 GET  ret={r} value={float(mf_g3_1.value)}")
ic.IC_SetPropertyAbsoluteValue(hGrabber, tis.T("Multi-Frame Output Mode"), tis.T("Gain 3"), ctypes.c_float(3.0))
r = ic.IC_GetPropertyAbsoluteValue(hGrabber, tis.T("Multi-Frame Output Mode"), tis.T("Gain 3"), mf_g3_2)
print(f"[Abs]  MFOM / Gain 3 GET2 ret={r} value={float(mf_g3_2.value)}")
print("------------------------------------------------------------\n")




# ============================================================
# 特別タブ　外部トリガー
# ============================================================
#トリガー
tr_en1 = ctypes.c_long()
tr_en2 = ctypes.c_long()
r = ic.IC_GetPropertySwitch(hGrabber, tis.T("Trigger"), tis.T("Enable"), tr_en1)
print(f"[Switch] Trigger / Enable GET  ret={r} value={tr_en1.value}")
ic.IC_SetPropertySwitch(hGrabber, tis.T("Trigger"), tis.T("Enable"), 1)
r = ic.IC_GetPropertySwitch(hGrabber, tis.T("Trigger"), tis.T("Enable"), tr_en2)
print(f"[Switch] Trigger / Enable GET2 ret={r} value={tr_en2.value}")
print("------------------------------------------------------------")
#トリガー ソフトウェアトリガー
print("[Button] Trigger / Software Trigger")
ic.IC_PropertyOnePush(hGrabber, tis.T("Trigger"), tis.T("Software Trigger"))
print("------------------------------------------------------------")
#トリガー 極性
tr_pol1 = ctypes.c_long()
tr_pol2 = ctypes.c_long()
r = ic.IC_GetPropertySwitch(hGrabber, tis.T("Trigger"), tis.T("Polarity"), tr_pol1)
print(f"[Switch] Trigger / Polarity GET  ret={r} value={tr_pol1.value}")
ic.IC_SetPropertySwitch(hGrabber, tis.T("Trigger"), tis.T("Polarity"), 1)
r = ic.IC_GetPropertySwitch(hGrabber, tis.T("Trigger"), tis.T("Polarity"), tr_pol2)
print(f"[Switch] Trigger / Polarity GET2 ret={r} value={tr_pol2.value}")
print("------------------------------------------------------------")
#トリガー Exposure Mode
tr_em1 = ctypes.c_long()
tr_em2 = ctypes.c_long()
r = ic.IC_GetPropertyValue(hGrabber, tis.T("Trigger"), tis.T("Exposure Mode"), tr_em1)
print(f"[MapStrings] Trigger / Exposure Mode GET  ret={r} idx={tr_em1.value}")
ic.IC_SetPropertyValue(hGrabber, tis.T("Trigger"), tis.T("Exposure Mode"), -1)
r = ic.IC_GetPropertyValue(hGrabber, tis.T("Trigger"), tis.T("Exposure Mode"), tr_em2)
print(f"[MapStrings] Trigger / Exposure Mode GET2 ret={r} idx={tr_em2.value}")
print("------------------------------------------------------------")
#トリガー Delay
tr_delay1 = ctypes.c_float()
tr_delay2 = ctypes.c_float()
r = ic.IC_GetPropertyAbsoluteValue(hGrabber, tis.T("Trigger"), tis.T("Delay"), tr_delay1)
print(f"[Abs]  Trigger / Delay GET  ret={r} value={float(tr_delay1.value)}")
ic.IC_SetPropertyAbsoluteValue(hGrabber, tis.T("Trigger"), tis.T("Delay"), ctypes.c_float(3.2))
r = ic.IC_GetPropertyAbsoluteValue(hGrabber, tis.T("Trigger"), tis.T("Delay"), tr_delay2)
print(f"[Abs]  Trigger / Delay GET2 ret={r} value={float(tr_delay2.value)}")
print("------------------------------------------------------------")
#トリガー Debounce Time
tr_db1 = ctypes.c_float()
tr_db2 = ctypes.c_float()
r = ic.IC_GetPropertyAbsoluteValue(hGrabber, tis.T("Trigger"), tis.T("Debounce Time"), tr_db1)
print(f"[Abs]  Trigger / Debounce Time GET  ret={r} value={float(tr_db1.value)}")
ic.IC_SetPropertyAbsoluteValue(hGrabber, tis.T("Trigger"), tis.T("Debounce Time"), ctypes.c_float(1.0))
r = ic.IC_GetPropertyAbsoluteValue(hGrabber, tis.T("Trigger"), tis.T("Debounce Time"), tr_db2)
print(f"[Abs]  Trigger / Debounce Time GET2 ret={r} value={float(tr_db2.value)}")
print("------------------------------------------------------------")
#トリガー Mask Time
tr_mask1 = ctypes.c_float()
tr_mask2 = ctypes.c_float()
r = ic.IC_GetPropertyAbsoluteValue(hGrabber, tis.T("Trigger"), tis.T("Mask Time"), tr_mask1)
print(f"[Abs]  Trigger / Mask Time GET  ret={r} value={float(tr_mask1.value)}")
ic.IC_SetPropertyAbsoluteValue(hGrabber, tis.T("Trigger"), tis.T("Mask Time"), ctypes.c_float(1.0))
r = ic.IC_GetPropertyAbsoluteValue(hGrabber, tis.T("Trigger"), tis.T("Mask Time"), tr_mask2)
print(f"[Abs]  Trigger / Mask Time GET2 ret={r} value={float(tr_mask2.value)}")
print("------------------------------------------------------------")
#トリガー Noise Suppression Time
tr_ns1 = ctypes.c_float()
tr_ns2 = ctypes.c_float()
r = ic.IC_GetPropertyAbsoluteValue(hGrabber, tis.T("Trigger"), tis.T("Noise Suppression Time"), tr_ns1)
print(f"[Abs]  Trigger / Noise Suppression Time GET  ret={r} value={float(tr_ns1.value)}")
ic.IC_SetPropertyAbsoluteValue(hGrabber, tis.T("Trigger"), tis.T("Noise Suppression Time"), 100)
r = ic.IC_GetPropertyAbsoluteValue(hGrabber, tis.T("Trigger"), tis.T("Noise Suppression Time"), tr_ns2)
print(f"[Abs]  Trigger / Noise Suppression Time GET2 ret={r} value={float(tr_ns2.value)}")
print("------------------------------------------------------------")
#トリガー Burst Count
tr_bc1 = ctypes.c_long()
tr_bc2 = ctypes.c_long()
r = ic.IC_GetPropertyValue(hGrabber, tis.T("Trigger"), tis.T("Burst Count"), tr_bc1)
print(f"[Range] Trigger / Burst Count GET  ret={r} value={tr_bc1.value}")
ic.IC_SetPropertyValue(hGrabber, tis.T("Trigger"), tis.T("Burst Count"), 1)
r = ic.IC_GetPropertyValue(hGrabber, tis.T("Trigger"), tis.T("Burst Count"), tr_bc2)
print(f"[Range] Trigger / Burst Count GET2 ret={r} value={tr_bc2.value}")
print("------------------------------------------------------------")
#トリガー Burst Interval
tr_bi1 = ctypes.c_long()
tr_bi2 = ctypes.c_long()
r = ic.IC_GetPropertyValue(hGrabber, tis.T("Trigger"), tis.T("Burst Interval"), tr_bi1)
print(f"[Range] Trigger / Burst Interval GET  ret={r} value={tr_bi1.value}")
ic.IC_SetPropertyValue(hGrabber, tis.T("Trigger"), tis.T("Burst Interval"), 100)
r = ic.IC_GetPropertyValue(hGrabber, tis.T("Trigger"), tis.T("Burst Interval"), tr_bi2)
print(f"[Range] Trigger / Burst Interval GET2 ret={r} value={tr_bi2.value}")
print("------------------------------------------------------------")
#トリガー Overlap
tr_ov1 = ctypes.c_long()
tr_ov2 = ctypes.c_long()
r = ic.IC_GetPropertyValue(hGrabber, tis.T("Trigger"), tis.T("Overlap"), tr_ov1)
print(f"[MapStrings] Trigger / Overlap GET  ret={r} idx={tr_ov1.value}")
print("------------------------------------------------------------")
#トリガー IMX Low-Latency Mode
tr_ll1 = ctypes.c_long()
tr_ll2 = ctypes.c_long()
r = ic.IC_GetPropertySwitch(hGrabber, tis.T("Trigger"), tis.T("IMX Low-Latency Mode"), tr_ll1)
print(f"[Switch] Trigger / IMX Low-Latency Mode GET  ret={r} value={tr_ll1.value}")
ic.IC_SetPropertySwitch(hGrabber, tis.T("Trigger"), tis.T("IMX Low-Latency Mode"), 0)
r = ic.IC_GetPropertySwitch(hGrabber, tis.T("Trigger"), tis.T("IMX Low-Latency Mode"), tr_ll2)
print(f"[Switch] Trigger / IMX Low-Latency Mode GET2 ret={r} value={tr_ll2.value}")
print("------------------------------------------------------------\n")
#GPIO　GPIO入力
gpio_in1 = ctypes.c_long()
gpio_in2 = ctypes.c_long()
r = ic.IC_GetPropertyValue(hGrabber, tis.T("GPIO"), tis.T("GP IN"), gpio_in1)
print(f"[Range] GPIO / GP IN GET  ret={r} value={gpio_in1.value}")
print("------------------------------------------------------------")

#GPIO　GPIO入力　読み取り
print("[Button] GPIO / Read")
ic.IC_PropertyOnePush(hGrabber, tis.T("GPIO"), tis.T("Read"))
print("------------------------------------------------------------")

#GPIO　GPIO出力
gpio_out1 = ctypes.c_long()
gpio_out2 = ctypes.c_long()
r = ic.IC_GetPropertyValue(hGrabber, tis.T("GPIO"), tis.T("GP Out"), gpio_out1)
print(f"[Range] GPIO / GP Out GET  ret={r} value={gpio_out1.value}")
ic.IC_SetPropertyValue(hGrabber, tis.T("GPIO"), tis.T("GP Out"), 1)
r = ic.IC_GetPropertyValue(hGrabber, tis.T("GPIO"), tis.T("GP Out"), gpio_out2)
print(f"[Range] GPIO / GP Out GET2 ret={r} value={gpio_out2.value}")
print("------------------------------------------------------------")

#GPIO　GPIO出力　書き込み
print("[Button] GPIO / Write")
ic.IC_PropertyOnePush(hGrabber, tis.T("GPIO"), tis.T("Write"))
print("------------------------------------------------------------\n")
#ストローブ　On/Off
st_en1 = ctypes.c_long()
st_en2 = ctypes.c_long()
r = ic.IC_GetPropertySwitch(hGrabber, tis.T("Strobe"), tis.T("Enable"), st_en1)
print(f"[Switch] Strobe / Enable GET  ret={r} value={st_en1.value}")
ic.IC_SetPropertySwitch(hGrabber, tis.T("Strobe"), tis.T("Enable"), 1)
r = ic.IC_GetPropertySwitch(hGrabber, tis.T("Strobe"), tis.T("Enable"), st_en2)
print(f"[Switch] Strobe / Enable GET2 ret={r} value={st_en2.value}")
print("------------------------------------------------------------")
#ストローブ　モード
st_mode1 = ctypes.c_long()
st_mode2 = ctypes.c_long()
r = ic.IC_GetPropertyValue(hGrabber, tis.T("Strobe"), tis.T("Mode"), st_mode1)
print(f"[MapStrings] Strobe / Mode GET  ret={r} idx={st_mode1.value}")
ic.IC_SetPropertyValue(hGrabber, tis.T("Strobe"), tis.T("Mode"), 0)
r = ic.IC_GetPropertyValue(hGrabber, tis.T("Strobe"), tis.T("Mode"), st_mode2)
print(f"[MapStrings] Strobe / Mode GET2 ret={r} idx={st_mode2.value}")
print("------------------------------------------------------------")
#ストローブ　極性
st_pol1 = ctypes.c_long()
st_pol2 = ctypes.c_long()
r = ic.IC_GetPropertySwitch(hGrabber, tis.T("Strobe"), tis.T("Polarity"), st_pol1)
print(f"[Switch] Strobe / Polarity GET  ret={r} value={st_pol1.value}")
ic.IC_SetPropertySwitch(hGrabber, tis.T("Strobe"), tis.T("Polarity"), 0)
r = ic.IC_GetPropertySwitch(hGrabber, tis.T("Strobe"), tis.T("Polarity"), st_pol2)
print(f"[Switch] Strobe / Polarity GET2 ret={r} value={st_pol2.value}")
print("------------------------------------------------------------")
#ストローブ　期間
st_dur1 = ctypes.c_long()
st_dur2 = ctypes.c_long()
r = ic.IC_GetPropertyValue(hGrabber, tis.T("Strobe"), tis.T("Duration"), st_dur1)
print(f"[Range] Strobe / Duration GET  ret={r} value={st_dur1.value}")
ic.IC_SetPropertyValue(hGrabber, tis.T("Strobe"), tis.T("Duration"), 10)
r = ic.IC_GetPropertyValue(hGrabber, tis.T("Strobe"), tis.T("Duration"), st_dur2)
print(f"[Range] Strobe / Duration GET2 ret={r} value={st_dur2.value}")
print("------------------------------------------------------------")
#ストローブ　遅延
st_del1 = ctypes.c_long()
st_del2 = ctypes.c_long()
r = ic.IC_GetPropertyValue(hGrabber, tis.T("Strobe"), tis.T("Delay"), st_del1)
print(f"[Range] Strobe / Delay GET  ret={r} value={st_del1.value}")
ic.IC_SetPropertyValue(hGrabber, tis.T("Strobe"), tis.T("Delay"), 10)
r = ic.IC_GetPropertyValue(hGrabber, tis.T("Strobe"), tis.T("Delay"), st_del2)
print(f"[Range] Strobe / Delay GET2 ret={r} value={st_del2.value}")
print("------------------------------------------------------------\n")

# ============================================================
# Color Correction
# ============================================================
#Color Correction Matrix　On/Off
ccm_en1 = ctypes.c_long()
ccm_en2 = ctypes.c_long()
r = ic.IC_GetPropertySwitch(hGrabber, tis.T("Color Correction Matrix"), tis.T("Enabled"), ccm_en1)
print(f"[Switch] Color Correction Matrix / Enabled GET  ret={r} value={ccm_en1.value}")
ic.IC_SetPropertySwitch(hGrabber, tis.T("Color Correction Matrix"), tis.T("Enabled"), 0)
r = ic.IC_GetPropertySwitch(hGrabber, tis.T("Color Correction Matrix"), tis.T("Enabled"), ccm_en2)
print(f"[Switch] Color Correction Matrix / Enabled GET2 ret={r} value={ccm_en2.value}")
print("------------------------------------------------------------")
#Color Correction Matrix　RR
ccm_rr1 = ctypes.c_float(); ccm_rr2 = ctypes.c_float()
r = ic.IC_GetPropertyAbsoluteValue(hGrabber, tis.T("Color Correction Matrix"), tis.T("RR"), ccm_rr1)
print(f"[Abs]  CCM / RR GET  ret={r} value={float(ccm_rr1.value)}")
ic.IC_SetPropertyAbsoluteValue(hGrabber, tis.T("Color Correction Matrix"), tis.T("RR"), ctypes.c_float(1.0))
r = ic.IC_GetPropertyAbsoluteValue(hGrabber, tis.T("Color Correction Matrix"), tis.T("RR"), ccm_rr2)
print(f"[Abs]  CCM / RR GET2 ret={r} value={float(ccm_rr2.value)}")
print("------------------------------------------------------------")
#Color Correction Matrix　RG
ccm_rg1 = ctypes.c_float(); ccm_rg2 = ctypes.c_float()
r = ic.IC_GetPropertyAbsoluteValue(hGrabber, tis.T("Color Correction Matrix"), tis.T("RG"), ccm_rg1)
print(f"[Abs]  CCM / RG GET  ret={r} value={float(ccm_rg1.value)}")
ic.IC_SetPropertyAbsoluteValue(hGrabber, tis.T("Color Correction Matrix"), tis.T("RG"), ctypes.c_float(1.0))
r = ic.IC_GetPropertyAbsoluteValue(hGrabber, tis.T("Color Correction Matrix"), tis.T("RG"), ccm_rg2)
print(f"[Abs]  CCM / RG GET2 ret={r} value={float(ccm_rg2.value)}")
print("------------------------------------------------------------")
#Color Correction Matrix　RB
ccm_rb1 = ctypes.c_float(); ccm_rb2 = ctypes.c_float()
r = ic.IC_GetPropertyAbsoluteValue(hGrabber, tis.T("Color Correction Matrix"), tis.T("RB"), ccm_rb1)
print(f"[Abs]  CCM / RB GET  ret={r} value={float(ccm_rb1.value)}")
ic.IC_SetPropertyAbsoluteValue(hGrabber, tis.T("Color Correction Matrix"), tis.T("RB"), ctypes.c_float(1.0))
r = ic.IC_GetPropertyAbsoluteValue(hGrabber, tis.T("Color Correction Matrix"), tis.T("RB"), ccm_rb2)
print(f"[Abs]  CCM / RB GET2 ret={r} value={float(ccm_rb2.value)}")
print("------------------------------------------------------------")
#Color Correction Matrix　GR
ccm_gr1 = ctypes.c_float(); ccm_gr2 = ctypes.c_float()
r = ic.IC_GetPropertyAbsoluteValue(hGrabber, tis.T("Color Correction Matrix"), tis.T("GR"), ccm_gr1)
print(f"[Abs]  CCM / GR GET  ret={r} value={float(ccm_gr1.value)}")
ic.IC_SetPropertyAbsoluteValue(hGrabber, tis.T("Color Correction Matrix"), tis.T("GR"), ctypes.c_float(1.0))
r = ic.IC_GetPropertyAbsoluteValue(hGrabber, tis.T("Color Correction Matrix"), tis.T("GR"), ccm_gr2)
print(f"[Abs]  CCM / GR GET2 ret={r} value={float(ccm_gr2.value)}")
print("------------------------------------------------------------")
#Color Correction Matrix　GG
ccm_gg1 = ctypes.c_float(); ccm_gg2 = ctypes.c_float()
r = ic.IC_GetPropertyAbsoluteValue(hGrabber, tis.T("Color Correction Matrix"), tis.T("GG"), ccm_gg1)
print(f"[Abs]  CCM / GG GET  ret={r} value={float(ccm_gg1.value)}")
ic.IC_SetPropertyAbsoluteValue(hGrabber, tis.T("Color Correction Matrix"), tis.T("GG"), ctypes.c_float(1.0))
r = ic.IC_GetPropertyAbsoluteValue(hGrabber, tis.T("Color Correction Matrix"), tis.T("GG"), ccm_gg2)
print(f"[Abs]  CCM / GG GET2 ret={r} value={float(ccm_gg2.value)}")
print("------------------------------------------------------------")
#Color Correction Matrix　GB
ccm_gb1 = ctypes.c_float(); ccm_gb2 = ctypes.c_float()
r = ic.IC_GetPropertyAbsoluteValue(hGrabber, tis.T("Color Correction Matrix"), tis.T("GB"), ccm_gb1)
print(f"[Abs]  CCM / GB GET  ret={r} value={float(ccm_gb1.value)}")
ic.IC_SetPropertyAbsoluteValue(hGrabber, tis.T("Color Correction Matrix"), tis.T("GB"), ctypes.c_float(1.0))
r = ic.IC_GetPropertyAbsoluteValue(hGrabber, tis.T("Color Correction Matrix"), tis.T("GB"), ccm_gb2)
print(f"[Abs]  CCM / GB GET2 ret={r} value={float(ccm_gb2.value)}")
print("------------------------------------------------------------")
#Color Correction Matrix　BR
ccm_br1 = ctypes.c_float(); ccm_br2 = ctypes.c_float()
r = ic.IC_GetPropertyAbsoluteValue(hGrabber, tis.T("Color Correction Matrix"), tis.T("BR"), ccm_br1)
print(f"[Abs]  CCM / BR GET  ret={r} value={float(ccm_br1.value)}")
ic.IC_SetPropertyAbsoluteValue(hGrabber, tis.T("Color Correction Matrix"), tis.T("BR"), ctypes.c_float(1.0))
r = ic.IC_GetPropertyAbsoluteValue(hGrabber, tis.T("Color Correction Matrix"), tis.T("BR"), ccm_br2)
print(f"[Abs]  CCM / BR GET2 ret={r} value={float(ccm_br2.value)}")
print("------------------------------------------------------------")
#Color Correction Matrix　BR
ccm_bg1 = ctypes.c_float(); ccm_bg2 = ctypes.c_float()
r = ic.IC_GetPropertyAbsoluteValue(hGrabber, tis.T("Color Correction Matrix"), tis.T("BG"), ccm_bg1)
print(f"[Abs]  CCM / BG GET  ret={r} value={float(ccm_bg1.value)}")
ic.IC_SetPropertyAbsoluteValue(hGrabber, tis.T("Color Correction Matrix"), tis.T("BG"), ctypes.c_float(1.0))
r = ic.IC_GetPropertyAbsoluteValue(hGrabber, tis.T("Color Correction Matrix"), tis.T("BG"), ccm_bg2)
print(f"[Abs]  CCM / BG GET2 ret={r} value={float(ccm_bg2.value)}")
print("------------------------------------------------------------")
#Color Correction Matrix　BB
ccm_bb1 = ctypes.c_float(); ccm_bb2 = ctypes.c_float()
r = ic.IC_GetPropertyAbsoluteValue(hGrabber, tis.T("Color Correction Matrix"), tis.T("BB"), ccm_bb1)
print(f"[Abs]  CCM / BB GET  ret={r} value={float(ccm_bb1.value)}")
ic.IC_SetPropertyAbsoluteValue(hGrabber, tis.T("Color Correction Matrix"), tis.T("BB"), ctypes.c_float(1.0))
r = ic.IC_GetPropertyAbsoluteValue(hGrabber, tis.T("Color Correction Matrix"), tis.T("BB"), ccm_bb2)
print(f"[Abs]  CCM / BB GET2 ret={r} value={float(ccm_bb2.value)}")
print("------------------------------------------------------------\n")



# ============================================================
# WDRタブ
# ============================================================
#Tone Mapping
tm_en1 = ctypes.c_long()
tm_en2 = ctypes.c_long()
r = ic.IC_GetPropertySwitch(hGrabber, tis.T("Tone Mapping"), tis.T("Enable"), tm_en1)
print(f"[Switch] Tone Mapping / Enable GET  ret={r} value={tm_en1.value}")
ic.IC_SetPropertySwitch(hGrabber, tis.T("Tone Mapping"), tis.T("Enable"), 1)
r = ic.IC_GetPropertySwitch(hGrabber, tis.T("Tone Mapping"), tis.T("Enable"), tm_en2)
print(f"[Switch] Tone Mapping / Enable GET2 ret={r} value={tm_en2.value}")
print("------------------------------------------------------------")
#Tone Mapping 自動　On/Off
tm_auto1 = ctypes.c_long()
tm_auto2 = ctypes.c_long()
r = ic.IC_GetPropertySwitch(hGrabber, tis.T("Tone Mapping"), tis.T("Auto"), tm_auto1)
print(f"[Switch] Tone Mapping / Auto GET  ret={r} value={tm_auto1.value}")
ic.IC_SetPropertySwitch(hGrabber, tis.T("Tone Mapping"), tis.T("Auto"), 1)
r = ic.IC_GetPropertySwitch(hGrabber, tis.T("Tone Mapping"), tis.T("Auto"), tm_auto2)
print(f"[Switch] Tone Mapping / Auto GET2 ret={r} value={tm_auto2.value}")
print("------------------------------------------------------------")

#Tone Mapping Intensity
tm_int1 = ctypes.c_float()
tm_int2 = ctypes.c_float()
r = ic.IC_GetPropertyAbsoluteValue(hGrabber, tis.T("Tone Mapping"), tis.T("Intensity"), tm_int1)
print(f"[Abs]  Tone Mapping / Intensity GET  ret={r} value={float(tm_int1.value)}")
ic.IC_SetPropertyAbsoluteValue(hGrabber, tis.T("Tone Mapping"), tis.T("Intensity"), ctypes.c_float(1.0))
r = ic.IC_GetPropertyAbsoluteValue(hGrabber, tis.T("Tone Mapping"), tis.T("Intensity"), tm_int2)
print(f"[Abs]  Tone Mapping / Intensity GET2 ret={r} value={float(tm_int2.value)}")
print("------------------------------------------------------------")
#Tone Mapping Global Brightness Factor
tm_gbf1 = ctypes.c_float()
tm_gbf2 = ctypes.c_float()
r = ic.IC_GetPropertyAbsoluteValue(hGrabber, tis.T("Tone Mapping"), tis.T("Global Brightness Factor"), tm_gbf1)
print(f"[Abs]  Tone Mapping / Global Brightness Factor GET  ret={r} value={float(tm_gbf1.value)}")
ic.IC_SetPropertyAbsoluteValue(hGrabber, tis.T("Tone Mapping"), tis.T("Global Brightness Factor"), ctypes.c_float(1.0))
r = ic.IC_GetPropertyAbsoluteValue(hGrabber, tis.T("Tone Mapping"), tis.T("Global Brightness Factor"), tm_gbf2)
print(f"[Abs]  Tone Mapping / Global Brightness Factor GET2 ret={r} value={float(tm_gbf2.value)}")
print("------------------------------------------------------------")



# ============================================================
# 切り出しタブ
# ============================================================
#切り出し設定　オートセンター
ps_ac1 = ctypes.c_long()
ps_ac2 = ctypes.c_long()
r = ic.IC_GetPropertySwitch(hGrabber, tis.T("Partial scan"), tis.T("Auto-center"), ps_ac1)
print(f"[Switch] Partial scan / Auto-center GET  ret={r} value={ps_ac1.value}")
ic.IC_SetPropertySwitch(hGrabber, tis.T("Partial scan"), tis.T("Auto-center"), 0)
r = ic.IC_GetPropertySwitch(hGrabber, tis.T("Partial scan"), tis.T("Auto-center"), ps_ac2)
print(f"[Switch] Partial scan / Auto-center GET2 ret={r} value={ps_ac2.value}")
print("------------------------------------------------------------")
#切り出し設定　切り出し位置オフセットX
ps_x1 = ctypes.c_long()
ps_x2 = ctypes.c_long()
r = ic.IC_GetPropertyValue(hGrabber, tis.T("Partial scan"), tis.T("X Offset"), ps_x1)
print(f"[Range] Partial scan / X Offset GET  ret={r} value={ps_x1.value}")
ic.IC_SetPropertyValue(hGrabber, tis.T("Partial scan"), tis.T("X Offset"), 10)
r = ic.IC_GetPropertyValue(hGrabber, tis.T("Partial scan"), tis.T("X Offset"), ps_x2)
print(f"[Range] Partial scan / X Offset GET2 ret={r} value={ps_x2.value}")
print("------------------------------------------------------------")
#切り出し設定　切り出し位置オフセットY
ps_y1 = ctypes.c_long()
ps_y2 = ctypes.c_long()
r = ic.IC_GetPropertyValue(hGrabber, tis.T("Partial scan"), tis.T("Y Offset"), ps_y1)
print(f"[Range] Partial scan / Y Offset GET  ret={r} value={ps_y1.value}")
ic.IC_SetPropertyValue(hGrabber, tis.T("Partial scan"), tis.T("Y Offset"), 10)
r = ic.IC_GetPropertyValue(hGrabber, tis.T("Partial scan"), tis.T("Y Offset"), ps_y2)
print(f"[Range] Partial scan / Y Offset GET2 ret={r} value={ps_y2.value}")
print("------------------------------------------------------------\n")

# ============================================================
# Auto ROI
# ============================================================
#Auto Functions ROI On/Off
afr_en1 = ctypes.c_long()
afr_en2 = ctypes.c_long()
r = ic.IC_GetPropertySwitch(hGrabber, tis.T("Auto Functions ROI"), tis.T("Enabled"), afr_en1)
print(f"[Switch] Auto Functions ROI / Enabled GET  ret={r} value={afr_en1.value}")
ic.IC_SetPropertySwitch(hGrabber, tis.T("Auto Functions ROI"), tis.T("Enabled"), 0)
r = ic.IC_GetPropertySwitch(hGrabber, tis.T("Auto Functions ROI"), tis.T("Enabled"), afr_en2)
print(f"[Switch] Auto Functions ROI / Enabled GET2 ret={r} value={afr_en2.value}")
print("------------------------------------------------------------")
#Auto Functions ROI Preset
afr_p1 = ctypes.c_long()
afr_p2 = ctypes.c_long()
r = ic.IC_GetPropertyValue(hGrabber, tis.T("Auto Functions ROI"), tis.T("Preset"), afr_p1)
print(f"[MapStrings] Auto Functions ROI / Preset GET  ret={r} idx={afr_p1.value}")
ic.IC_SetPropertyValue(hGrabber, tis.T("Auto Functions ROI"), tis.T("Preset"), 0)
r = ic.IC_GetPropertyValue(hGrabber, tis.T("Auto Functions ROI"), tis.T("Preset"), afr_p2)
print(f"[MapStrings] Auto Functions ROI / Preset GET2 ret={r} idx={afr_p2.value}")
print("------------------------------------------------------------")
#Auto Functions ROI Left
afr_l1 = ctypes.c_float(); afr_l2 = ctypes.c_float()
r = ic.IC_GetPropertyAbsoluteValue(hGrabber, tis.T("Auto Functions ROI"), tis.T("Left"), afr_l1)
print(f"[Abs]  Auto Functions ROI / Left GET  ret={r} value={float(afr_l1.value)}")
ic.IC_SetPropertyAbsoluteValue(hGrabber, tis.T("Auto Functions ROI"), tis.T("Left"), ctypes.c_float(25.0))
r = ic.IC_GetPropertyAbsoluteValue(hGrabber, tis.T("Auto Functions ROI"), tis.T("Left"), afr_l2)
print(f"[Abs]  Auto Functions ROI / Left GET2 ret={r} value={float(afr_l2.value)}")
print("------------------------------------------------------------")
#Auto Functions ROI Top
afr_t1 = ctypes.c_float(); afr_t2 = ctypes.c_float()
r = ic.IC_GetPropertyAbsoluteValue(hGrabber, tis.T("Auto Functions ROI"), tis.T("Top"), afr_t1)
print(f"[Abs]  Auto Functions ROI / Top GET  ret={r} value={float(afr_t1.value)}")
ic.IC_SetPropertyAbsoluteValue(hGrabber, tis.T("Auto Functions ROI"), tis.T("Top"), ctypes.c_float(25.0))
r = ic.IC_GetPropertyAbsoluteValue(hGrabber, tis.T("Auto Functions ROI"), tis.T("Top"), afr_t2)
print(f"[Abs]  Auto Functions ROI / Top GET2 ret={r} value={float(afr_t2.value)}")
print("------------------------------------------------------------")
#Auto Functions ROI Width
afr_w1 = ctypes.c_float(); afr_w2 = ctypes.c_float()
r = ic.IC_GetPropertyAbsoluteValue(hGrabber, tis.T("Auto Functions ROI"), tis.T("Width"), afr_w1)
print(f"[Abs]  Auto Functions ROI / Width GET  ret={r} value={float(afr_w1.value)}")
ic.IC_SetPropertyAbsoluteValue(hGrabber, tis.T("Auto Functions ROI"), tis.T("Width"), ctypes.c_float(25.0))
r = ic.IC_GetPropertyAbsoluteValue(hGrabber, tis.T("Auto Functions ROI"), tis.T("Width"), afr_w2)
print(f"[Abs]  Auto Functions ROI / Width GET2 ret={r} value={float(afr_w2.value)}")
print("------------------------------------------------------------")
#Auto Functions ROI Height
afr_h1 = ctypes.c_float(); afr_h2 = ctypes.c_float()
r = ic.IC_GetPropertyAbsoluteValue(hGrabber, tis.T("Auto Functions ROI"), tis.T("Height"), afr_h1)
print(f"[Abs]  Auto Functions ROI / Height GET  ret={r} value={float(afr_h1.value)}")
ic.IC_SetPropertyAbsoluteValue(hGrabber, tis.T("Auto Functions ROI"), tis.T("Height"), ctypes.c_float(25.0))
r = ic.IC_GetPropertyAbsoluteValue(hGrabber, tis.T("Auto Functions ROI"), tis.T("Height"), afr_h2)
print(f"[Abs]  Auto Functions ROI / Height GET2 ret={r} value={float(afr_h2.value)}")
print("------------------------------------------------------------\n")


# ============================================================
# レンズタブ
# ============================================================
#ズーム
vL = ctypes.c_long()
vF = ctypes.c_float()
print("[Range] Zoom / Value")
vL.value = 0
r = ic.IC_GetPropertyValue(hGrabber, tis.T("Zoom"), tis.T("Value"), vL)
print(f"  GET  ret={r} value={vL.value}")
r = ic.IC_SetPropertyValue(hGrabber, tis.T("Zoom"), tis.T("Value"), 1000)
vL.value = 0
r = ic.IC_GetPropertyValue(hGrabber, tis.T("Zoom"), tis.T("Value"), vL)
print(f"  GET2 ret={r} value={vL.value}")
print("------------------------------------------------------------\n")
#アイリス
print("[Range] Iris / Value")
vL.value = 0
r = ic.IC_GetPropertyValue(hGrabber, tis.T("Iris"), tis.T("Value"), vL)
print(f"  GET  ret={r} value={vL.value}")
r = ic.IC_SetPropertyValue(hGrabber, tis.T("Iris"), tis.T("Value"), 255)
vL.value = 0
r = ic.IC_GetPropertyValue(hGrabber, tis.T("Iris"), tis.T("Value"), vL)
print(f"  GET2 ret={r} value={vL.value}")
print("------------------------------------------------------------\n")
#アイリス 自動
print("[Switch] Iris / Auto")
vL.value = 0
r = ic.IC_GetPropertySwitch(hGrabber, tis.T("Iris"), tis.T("Auto"), vL)
print(f"  GET  ret={r} value={vL.value}")
r = ic.IC_SetPropertySwitch(hGrabber, tis.T("Iris"), tis.T("Auto"), 0)
vL.value = 0
r = ic.IC_GetPropertySwitch(hGrabber, tis.T("Iris"), tis.T("Auto"), vL)
print(f"  GET2 ret={r} value={vL.value}")
print("------------------------------------------------------------\n")
#焦点
print("[Range] Focus / Value")
vL.value = 0
r = ic.IC_GetPropertyValue(hGrabber, tis.T("Focus"), tis.T("Value"), vL)
print(f"  GET  ret={r} value={vL.value}")
r = ic.IC_SetPropertyValue(hGrabber, tis.T("Focus"), tis.T("Value"), 2000)
vL.value = 0
r = ic.IC_GetPropertyValue(hGrabber, tis.T("Focus"), tis.T("Value"), vL)
print(f"  GET2 ret={r} value={vL.value}")
print("------------------------------------------------------------\n")
#焦点　ワンプッシュ
print("[Button] Focus / One Push")
# Buttonは Set/Get というより「実行」なので、ここは実行のみ
ic.IC_PropertyOnePush(hGrabber, tis.T("Focus"), tis.T("One Push"))
print("------------------------------------------------------------\n")
#焦点　One Push Running
print("[Switch] Focus / One Push Running")
vL.value = 0
r = ic.IC_GetPropertySwitch(hGrabber, tis.T("Focus"), tis.T("One Push Running"), vL)
print(f"  GET  ret={r} value={vL.value}")
print("------------------------------------------------------------\n")
#焦点　Enabled
print("[Switch] Focus / Enabled")
vL.value = 0
r = ic.IC_GetPropertySwitch(hGrabber, tis.T("Focus"), tis.T("Enabled"), vL)
print(f"  GET  ret={r} value={vL.value}")
r = ic.IC_SetPropertySwitch(hGrabber, tis.T("Focus"), tis.T("Enabled"), 1)
vL.value = 0
r = ic.IC_GetPropertySwitch(hGrabber, tis.T("Focus"), tis.T("Enabled"), vL)
print(f"  GET2 ret={r} value={vL.value}")
print("------------------------------------------------------------\n")
#焦点　Left
print("[Range] Focus / Left")
vL.value = 0
r = ic.IC_GetPropertyValue(hGrabber, tis.T("Focus"), tis.T("Left"), vL)
print(f"  GET  ret={r} value={vL.value}")
r = ic.IC_SetPropertyValue(hGrabber, tis.T("Focus"), tis.T("Left"), 25)
vL.value = 0
r = ic.IC_GetPropertyValue(hGrabber, tis.T("Focus"), tis.T("Left"), vL)
print(f"  GET2 ret={r} value={vL.value}")
print("------------------------------------------------------------\n")
#焦点　Top
print("[Range] Focus / Top")
vL.value = 0
r = ic.IC_GetPropertyValue(hGrabber, tis.T("Focus"), tis.T("Top"), vL)
print(f"  GET  ret={r} value={vL.value}")
r = ic.IC_SetPropertyValue(hGrabber, tis.T("Focus"), tis.T("Top"), 25)
vL.value = 0
r = ic.IC_GetPropertyValue(hGrabber, tis.T("Focus"), tis.T("Top"), vL)
print(f"  GET2 ret={r} value={vL.value}")
print("------------------------------------------------------------\n")
#焦点　Right
print("[Range] Focus / Right")
vL.value = 0
r = ic.IC_GetPropertyValue(hGrabber, tis.T("Focus"), tis.T("Right"), vL)
print(f"  GET  ret={r} value={vL.value}")
r = ic.IC_SetPropertyValue(hGrabber, tis.T("Focus"), tis.T("Right"), 1000)
vL.value = 0
r = ic.IC_GetPropertyValue(hGrabber, tis.T("Focus"), tis.T("Right"), vL)
print(f"  GET2 ret={r} value={vL.value}")
print("------------------------------------------------------------\n")
#焦点　Bottom
print("[Range] Focus / Bottom")
vL.value = 0
r = ic.IC_GetPropertyValue(hGrabber, tis.T("Focus"), tis.T("Bottom"), vL)
print(f"  GET  ret={r} value={vL.value}")
r = ic.IC_SetPropertyValue(hGrabber, tis.T("Focus"), tis.T("Bottom"), 800)
vL.value = 0
r = ic.IC_GetPropertyValue(hGrabber, tis.T("Focus"), tis.T("Bottom"), vL)
print(f"  GET2 ret={r} value={vL.value}")
print("------------------------------------------------------------\n")
#IR-Cut Filter
print("[Switch] IR-Cut Filter / Enable")
vL.value = 0
r = ic.IC_GetPropertySwitch(hGrabber, tis.T("IR-Cut Filter"), tis.T("Enable"), vL)
print(f"  GET  ret={r} value={vL.value}")
r = ic.IC_SetPropertySwitch(hGrabber, tis.T("IR-Cut Filter"), tis.T("Enable"), 1)
vL.value = 0
r = ic.IC_GetPropertySwitch(hGrabber, tis.T("IR-Cut Filter"), tis.T("Enable"), vL)
print(f"  GET2 ret={r} value={vL.value}")
print("------------------------------------------------------------\n")



# ============================================================
# HDMIタブ(DFG/HDMIのみ)
# ============================================================
# Source Connected 
print("[Switch] Source Connected / Value")
vL.value = 0
r = ic.IC_GetPropertySwitch(hGrabber, tis.T("Source Connected"), tis.T("Value"), vL)
print(f"  GET  ret={r} value={vL.value}")
print("------------------------------------------------------------\n")
#Expand Output Range
print("[Switch] Expand Output Range / Value")
vL.value = 0
r = ic.IC_GetPropertySwitch(hGrabber, tis.T("Expand Output Range"), tis.T("Value"), vL)
print(f"  GET  ret={r} value={vL.value}")
r = ic.IC_SetPropertySwitch(hGrabber, tis.T("Expand Output Range"), tis.T("Value"), 1)
vL.value = 0
r = ic.IC_GetPropertySwitch(hGrabber, tis.T("Expand Output Range"), tis.T("Value"), vL)
print(f"  GET2 ret={r} value={vL.value}")
print("------------------------------------------------------------\n")
#信号検知
print("[Switch] Signal Detected / Value")
vL.value = 0
r = ic.IC_GetPropertySwitch(hGrabber, tis.T("Signal Detected"), tis.T("Value"), vL)
print(f"  GET  ret={r} value={vL.value}")
print("------------------------------------------------------------\n")
#信号検知　Input Width
print("[Range] Signal Detected / Input Width")
vL.value = 0
r = ic.IC_GetPropertyValue(hGrabber, tis.T("Signal Detected"), tis.T("Input Width"), vL)
print(f"  GET  ret={r} value={vL.value}")
print("------------------------------------------------------------\n")
#信号検知　Input Height
print("[Range] Signal Detected / Input Height")
vL.value = 0
r = ic.IC_GetPropertyValue(hGrabber, tis.T("Signal Detected"), tis.T("Input Height"), vL)
print(f"  GET  ret={r} value={vL.value}")
print("------------------------------------------------------------\n")
#信号検知　Input Fp1ks
print("[Range] Signal Detected / Input Fp1ks")
vL.value = 0
r = ic.IC_GetPropertyValue(hGrabber, tis.T("Signal Detected"), tis.T("Input Fp1ks"), vL)
print(f"  GET  ret={r} value={vL.value}")
print("------------------------------------------------------------\n")
#信号検知　Input Bits
print("[Range] Signal Detected / Input Bits")
vL.value = 0
r = ic.IC_GetPropertyValue(hGrabber, tis.T("Signal Detected"), tis.T("Input Bits"), vL)
print(f"  GET  ret={r} value={vL.value}")
print("------------------------------------------------------------\n")
#Disable Info Overlay
print("[Switch] Disable Info Overlay / Value")
vL.value = 0
r = ic.IC_GetPropertySwitch(hGrabber, tis.T("Disable Info Overlay"), tis.T("Value"), vL)
print(f"  GET  ret={r} value={vL.value}")
r = ic.IC_SetPropertySwitch(hGrabber, tis.T("Disable Info Overlay"), tis.T("Value"), 1)
vL.value = 0
r = ic.IC_GetPropertySwitch(hGrabber, tis.T("Disable Info Overlay"), tis.T("Value"), vL)
print(f"  GET2 ret={r} value={vL.value}")
print("------------------------------------------------------------\n")


#ライブストップ
ic.IC_StopLive(hGrabber)

ic.IC_ReleaseGrabber(hGrabber)
